#define	GLSL_DEFORM_WAVE	1.0
#define	GLSL_DEFORM_WAVE_FREQ	2.0
#define	GLSL_DEFORM_BULGE	3.0
#define	GLSL_DEFORM_MOVE	4.0

#define	GF_NONE			0.0
#define	GF_SIN			1.0
#define	GF_SQUARE		2.0
#define	GF_TRIANGLE		3.0
#define	GF_SAWTOOTH		4.0
#define	GF_INVERSE_SAWTOOTH	5.0

uniform	float	u_deformParms[25];	// MAX_SHADER_DEFORMS * 7 + MAX_SHADER_DEFORMS + 1

float WAVEVALUE(float table, float base, float amplitude, float phasePLUSfreq)
{
	if (table == GF_NONE)
		return 0.0;
	if (table == GF_SIN)
		return base + sin(phasePLUSfreq) * amplitude;
	if (table == GF_SQUARE)
		return base + sign(sin(phasePLUSfreq)) * amplitude;
	if (table == GF_TRIANGLE)
		return base + max(1.0 - abs(phasePLUSfreq), 0.0) * amplitude;
	if (table == GF_SAWTOOTH)
		return base + (phasePLUSfreq - floor(phasePLUSfreq)) * amplitude;
///	if (table == GF_INVERSE_SAWTOOTH)
		return base + (1.0 - (phasePLUSfreq - floor(phasePLUSfreq))) * amplitude;
}

vec4 DeformGeometry()
{
	float f;
	int j, deformOffs = 0;
	int numDeforms = int(u_deformParms[deformOffs++]);
	vec4 xyz = gl_Vertex;
	for (j=0; j<numDeforms; j++)
	{
		f = u_deformParms[deformOffs++];
		if (f == GLSL_DEFORM_WAVE)
		{	// queue:
			//	table
			//	base
			//	amplitude
			//	phase + 0.0
			xyz.xyz += gl_Normal.xyz * WAVEVALUE(u_deformParms[deformOffs++], u_deformParms[deformOffs++], u_deformParms[deformOffs++], u_deformParms[deformOffs++]);
		}
		if (f == GLSL_DEFORM_WAVE_FREQ)
		{	// queue:
			//	deformationSpread
			//	table
			//	base
			//	amplitude
			//	phase + freq
			float off = 6.2831853072 * ( xyz.x + xyz.y + xyz.z ) * u_deformParms[deformOffs++];
			xyz.xyz += gl_Normal.xyz * WAVEVALUE(u_deformParms[deformOffs++], u_deformParms[deformOffs++], u_deformParms[deformOffs++], u_deformParms[deformOffs++] + off);
		}
		if (f == GLSL_DEFORM_BULGE)
		{	// queue:
			//	backEnd.refdef.time * ds->bulgeSpeed * 0.001f
			//	ds->bulgeWidth
			//	ds->bulgeHeight
			float now = u_deformParms[deformOffs++];
			float off = 0.7853981634 * gl_MultiTexCoord0.s * u_deformParms[deformOffs++] + now;
			xyz.xyz += gl_Normal.xyz * sin(off) * u_deformParms[deformOffs++];
		}
		if (f == GLSL_DEFORM_MOVE)
		{	// queue:
			//	ds->moveVector[0]
			//	ds->moveVector[1]
			//	ds->moveVector[2]
			//	table
			//	base
			//	amplitude
			//	phase + freq
			vec3 moveVector = vec3(u_deformParms[deformOffs++], u_deformParms[deformOffs++], u_deformParms[deformOffs++]);
			xyz.xyz += moveVector * WAVEVALUE(u_deformParms[deformOffs++], u_deformParms[deformOffs++], u_deformParms[deformOffs++], u_deformParms[deformOffs++]);
		}
	}
	return xyz;
}
